;C prototype: void DrawSprite8_SHADOW (short x, short y, short h, void *sprite, void *dest);
;
;void DrawSprite8_SHADOW (register short x asm("%d0"),
;		     register short y asm("%d1"),
;		     register short h asm("%d2"),
;		     register void *sprite asm("%a1"),
;		     register void *dest asm("%a0"));

	xdef	_DrawSprite8_SHADOW

_DrawSprite8_SHADOW:
    dbf      d2,suite
    rts

suite:
    move.l   d3,-(a7)
    move.l   d4,-(a7)

    move.w   d1,d3	; d3 = y
    lsl.w    #4,d1	; d1 = 16*y
    sub.w    d3,d1	; d1 = 15*y

    move.w   d0,d3	; d3 = x
    lsr.w    #4,d3	; d3 = x/16

    add.w    d3,d1	; d1 = 15*y + x/16
    add.w    d1,d1	; d1 = 30*y + x/8
    adda.w   d1,a0	; a0 += offset

    and.w    #$0F,d0
    moveq.l  #8,d1
    sub.w    d0,d1
    bgt.s    pre_loop_Sprite8_OR_2

    addi.w   #16,d1

    lsr.w    #1,d2
    bcs.s    _loop_Sprite8_OR_1

    lea.l    -30(a0),a0
    bra.s    Milieu1

_loop_Sprite8_OR_1:
    move.l   (a0),d0
    move.l   6000(a0),d4
    
    ; shadow
    move.l   d0,d3
    not.l    d3
    or.l     d4,d3
    or.l     d0,d4
    
    moveq.l  #-1,d0
    move.b   (a1)+,d0
    rol.l    d1,d0
    and.l    d0,(a0)
    and.l    d0,6000(a0)
    not.l    d0
    and.l    d0,d3
    and.l    d0,d4
    
    ; Zone d'ombres
    or.l     d3,(a0)
    or.l     d4,6000(a0)
    
    addq.l   #2,a1

Milieu1:
    move.l   30(a0),d0
    move.l   6000+30(a0),d4
    
    ; shadow
    move.l   d0,d3
    not.l    d3
    or.l     d4,d3
    or.l     d0,d4
    
    moveq.l  #-1,d0
    move.b   (a1)+,d0
    rol.l    d1,d0
    and.l    d0,30(a0)
    and.l    d0,6000+30(a0)
    not.l    d0
    and.l    d0,d3
    and.l    d0,d4
    
    ; Zone d'ombres
    or.l     d3,30(a0)
    or.l     d4,6000+30(a0)

    addq.l   #2,a1
    lea      60(a0),a0

    dbf      d2,_loop_Sprite8_OR_1
    move.l   (a7)+,d4
    move.l   (a7)+,d3    
    rts

pre_loop_Sprite8_OR_2:
    lsr.w    #1,d2
    bcs.s    _loop_Sprite8_OR_2

    lea.l    -30(a0),a0
    bra.s    Milieu2

_loop_Sprite8_OR_2:
    move.w   (a0),d0
    move.w   6000(a0),d4
    
    ; shadow
    move.w   d0,d3
    not.w    d3
    or.w     d4,d3
    or.w     d0,d4
    
    moveq.l  #-1,d0
    move.b   (a1)+,d0
    swap.w   d0
    rol.l    d1,d0
    and.l    d0,(a0)
    and.l    d0,6000(a0)
    not.l    d0
    swap.w   d0
    and.l    d0,d3
    and.l    d0,d4
    
    ; Zone d'ombres
    or.w     d3,(a0)
    or.w     d4,6000(a0)
    
    addq.l   #2,a1

Milieu2:
    move.w   30(a0),d0
    move.w   6000+30(a0),d4
    
    ; shadow
    move.w   d0,d3
    not.w    d3
    or.w     d4,d3
    or.w     d0,d4
    
    moveq.l  #-1,d0
    move.b   (a1)+,d0
    swap.w   d0
    rol.l    d1,d0
    and.l    d0,30(a0)
    and.l    d0,6000+30(a0)
    not.l    d0
    swap.w   d0
    and.l    d0,d3
    and.l    d0,d4
    
    ; Zone d'ombres
    or.w     d3,30(a0)
    or.w     d4,6000+30(a0)

    addq.l   #2,a1
    lea      60(a0),a0

    dbf      d2,_loop_Sprite8_OR_2
    move.l   (a7)+,d4
    move.l   (a7)+,d3
    rts